/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class TimeCalculator
extends JApplet
implements ActionListener,
KeyListener {
    private final int ENTERKEY = 10;
    private final int PLUSKEY = 107;
    private final char DEVIDERCHAR = (char)58;
    private final String ADD = "Add";
    private final String CLEAR = "Clear";
    private final String LNF = "LNF";
    private final String INFO = "Info";
    private final String REMOVE = "Remove";
    private int totalMinutes = 0;
    private int totalSeconds = 0;
    private int addMinutes = 0;
    private int addSeconds = 0;
    private int lnfType = 0;
    private boolean inAnApplet = false;
    private Vector times = new Vector();
    private JList countList = new JList();
    private JTextField countField = new JTextField();
    private JTextField totalField = new JTextField();
    private JTextField timeField = new JTextField();
    private JButton countBtn = new JButton("Add");
    private JButton clearBtn = new JButton("Clear");
    private JButton infoBtn = new JButton("Info");
    private JButton lnfBtn = new JButton("LNF");
    private JButton removeBtn = new JButton("Remove");
    private JPanel pane = new JPanel();

    public TimeCalculator() {
        this(true);
    }

    public TimeCalculator(boolean bl) {
        this.inAnApplet = bl;
        if (bl) {
            this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        }
        this.buildScreen();
        this.addListeners();
    }

    public void init() {
        this.setContentPane(this.getTimeCalculatorPane());
    }

    private Container getTimeCalculatorPane() {
        return this.pane;
    }

    private void buildScreen() {
        JScrollPane jScrollPane = new JScrollPane(this.countList);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.lnfBtn, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.infoBtn, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Entered Times:"), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Number of Times:"), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.countField, new GridBagConstraints(0, 4, 2, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Total Time:"), new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.totalField, new GridBagConstraints(0, 6, 2, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Enter Time:"), new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.timeField, new GridBagConstraints(0, 8, 2, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.countBtn, new GridBagConstraints(0, 9, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.clearBtn, new GridBagConstraints(1, 9, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.removeBtn, new GridBagConstraints(0, 10, 2, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.lnfBtn.setActionCommand("LNF");
        jScrollPane.setPreferredSize(new Dimension(100, 300));
        this.countField.setEnabled(false);
        this.totalField.setEnabled(false);
        this.pane.setLayout(new GridBagLayout());
        this.pane.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 2, 2), 0, 0));
        this.pane.setVisible(true);
        this.timeField.grabFocus();
    }

    private void addListeners() {
        this.timeField.addKeyListener(this);
        this.countBtn.addActionListener(this);
        this.clearBtn.addActionListener(this);
        this.lnfBtn.addActionListener(this);
        this.infoBtn.addActionListener(this);
        this.removeBtn.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add")) {
            this.addTime(false);
        }
        if (string.equals("Clear")) {
            this.clearTimes();
        }
        if (string.equals("LNF")) {
            this.setLNF();
        }
        if (string.equals("Info")) {
            this.showInfo();
        }
        if (string.equals("Remove")) {
            this.removeSelectedTimes();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.addTime(false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 107) {
            this.addTime(true);
        }
    }

    private void countTimes() {
        this.totalSeconds += this.addSeconds;
        if (this.totalSeconds > 59) {
            this.totalSeconds %= 60;
            ++this.totalMinutes;
        }
        this.totalMinutes += this.addMinutes;
    }

    private void removeTime(int n, int n2) {
        this.totalSeconds -= n2;
        if (this.totalSeconds < 0) {
            this.totalSeconds += 60;
            --this.totalMinutes;
        }
        this.totalMinutes -= n;
    }

    private int[] getSelectedTime(String string) {
        int[] nArray = new int[]{0, 0};
        int n = string.indexOf(58);
        nArray[0] = Integer.parseInt(string.substring(0, n));
        nArray[1] = Integer.parseInt(string.substring(n + 1));
        return nArray;
    }

    private String parseInput(String string) throws NumberFormatException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        String string3 = "";
        string = string.replace(' ', ':');
        string = string.replace('.', ':');
        string = string.replace(',', ':');
        string = string.replace(';', ':');
        string = string.replace('\'', ':');
        string = string.replace('\"', ':');
        n3 = string.indexOf(58);
        switch (n3) {
            case -1: {
                string2 = new String(string);
                n = Integer.parseInt(string2);
                break;
            }
            case 0: {
                string3 = string.substring(1);
                if (string3.equals("")) {
                    n2 = 0;
                    break;
                }
                n2 = Integer.parseInt(string3);
                break;
            }
            default: {
                string2 = string.substring(0, n3);
                string3 = string.substring(n3 + 1);
                n = Integer.parseInt(string2);
                if (string3.equals("")) {
                    n2 = 0;
                    break;
                }
                n2 = Integer.parseInt(string3);
                break;
            }
        }
        if (n < 0 || n2 < 0 || n2 > 59) {
            throw new NumberFormatException("Minutes must be a positive integer and seconds must be an integer between 0 and 59.");
        }
        this.addMinutes = n;
        this.addSeconds = n2;
        return this.createTimeString(n, n2);
    }

    private String createTimeString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(':');
        if (n2 == 0) {
            stringBuffer.append("00");
        } else {
            if (n2 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    private void updateCountField() {
        this.countField.setText(Integer.toString(this.times.size()));
    }

    private void updateTotalTime() {
        String string = this.createTimeString(this.totalMinutes, this.totalSeconds);
        this.totalField.setText(string);
    }

    private void updateTimeList() {
        this.countList.setListData(this.times);
        this.countList.setSelectedIndex(-1);
        this.countList.ensureIndexIsVisible(this.times.size() - 1);
        this.timeField.setText("");
    }

    private void focusToInput() {
        this.countBtn.grabFocus();
        this.timeField.grabFocus();
        this.getRootPane().setDefaultButton(this.countBtn);
    }

    private void addTime(boolean bl) {
        String string = this.timeField.getText().trim();
        if (bl) {
            int n = string.length() - 1;
            if (n > 0) {
                string = string.substring(0, n);
            } else {
                string = "";
                this.timeField.setText("");
            }
        }
        if (!string.equals("")) {
            try {
                string = this.parseInput(string);
                this.times.add(string);
                this.countTimes();
                this.updateTimeList();
                this.updateTotalTime();
                this.updateCountField();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Please enter a valid time.\nExample: 2.15", "Input Error", 0);
            }
        }
        this.timeField.grabFocus();
    }

    private void removeSelectedTimes() {
        if (this.times.size() > 0) {
            Object[] objectArray = this.countList.getSelectedValues();
            int[] nArray = this.countList.getSelectedIndices();
            if (objectArray != null && objectArray.length > 0) {
                String string = null;
                int n = 0;
                while (n < objectArray.length) {
                    string = (String)objectArray[n];
                    int[] nArray2 = this.getSelectedTime(string);
                    this.removeTime(nArray2[0], nArray2[1]);
                    this.times.remove(nArray[n] - n);
                    ++n;
                }
                this.updateTimeList();
                this.updateTotalTime();
                this.updateCountField();
            } else {
                JOptionPane.showMessageDialog(this, "Please select at least one time to remove.", "Selection Error", 0);
            }
        }
        this.timeField.grabFocus();
    }

    private void clearTimes() {
        this.totalMinutes = 0;
        this.totalSeconds = 0;
        this.times.clear();
        this.updateTimeList();
        this.updateTotalTime();
        this.updateCountField();
        this.focusToInput();
    }

    private void setLNF() {
        try {
            try {
                ++this.lnfType;
                switch (this.lnfType) {
                    case 0: {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                        break;
                    }
                    case 1: {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                        break;
                    }
                    case 2: {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                        this.lnfType = -1;
                    }
                }
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                this.lnfType = 0;
            }
            catch (ClassNotFoundException classNotFoundException) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                this.lnfType = 0;
            }
            this.focusToInput();
            SwingUtilities.updateComponentTreeUI(this.getTimeCalculatorPane());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void showInfo() {
        JOptionPane.showMessageDialog(this, "Written by Peter A. J. Troon, 2001.\nContact: pajtroon@dds.nl\nURL: http://www.troon.org/", "More Information", 1);
        this.focusToInput();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Times");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        TimeCalculator timeCalculator = new TimeCalculator(false);
        jFrame.setContentPane(timeCalculator.getTimeCalculatorPane());
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
        timeCalculator.focusToInput();
    }
}

